package commands

import (
	"os"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/security/yadi/yadi-os/internal/cli"
	"a.yandex-team.ru/security/yadi/yadi-os/pkg/analyze"
	"a.yandex-team.ru/security/yadi/yadi-os/pkg/config"
	"a.yandex-team.ru/security/yadi/yadi-os/pkg/pkgmanager"
)

var listCmd = &cobra.Command{
	Use:   "list",
	Short: "list packages",
	RunE:  runListCmd,
}

func init() {
	rootCmd.AddCommand(listCmd)
}

func runListCmd(_ *cobra.Command, args []string) error {
	analyzer, err := analyze.New(analyze.Options{
		FeedURI:                config.FeedURI,
		MinimumSeverity:        config.MinimumSeverity,
		VulnerabilitiesExclude: rootOpts.SkipIssues,
		PackagesExclude:        rootOpts.SkipPackages,
	})

	if err != nil {
		return err
	}

	pkgManager, err := pkgmanager.DetectPkgManager(rootOpts.Root)
	if err != nil {
		if rootOpts.SkipUnknownOS && xerrors.Is(err, pkgmanager.ErrUnsupportedOs) {
			// that's fine
			return nil
		}
		return err
	}

	listResults, err := analyzer.ListPackages(pkgManager)
	if err != nil {
		return err
	}

	format, _ := cli.ListFormatter(rootOpts.Format)
	_, _ = os.Stdout.Write(format(listResults))
	return nil
}
