package analyze

import (
	"a.yandex-team.ru/security/yadi/yadi-os/pkg/feed"
	"a.yandex-team.ru/security/yadi/yadi-os/pkg/pkgmanager/manager"
)

type (
	Options struct {
		// Feed Url
		// Uri (or path to file) to download feed. May have placeholder for ecosystem
		// Example: https://yadi.yandex-team.ru/db/linux-{ecosystem}.json.gz
		FeedURI string

		// Ignore vulnerabilities that lower than that severity
		MinimumSeverity float32

		// Fetcher to use, instead create new one
		Fetcher *feed.Fetcher

		// List of excluded vulnerabilities
		VulnerabilitiesExclude []string

		// List of excluded packages
		PackagesExclude []string

		// Report only fixable issues, currently supported only fo os pkgs
		FixableOnly bool
	}

	DependencyExcludes struct {
		ModuleName string
		From       string
	}

	Issue struct {
		ID               string  `json:"id"`
		AffectedVersions string  `json:"affected_versions"`
		Summary          string  `json:"summary"`
		Reference        string  `json:"reference"`
		CVSSScore        float32 `json:"cvss_score"`
	}

	Issues []Issue

	ListPackagesResult []*manager.Package

	CheckKernelResult = Issues

	PackageVulnerabilities struct {
		Package         *manager.Package `json:"package"`
		Vulnerabilities Issues           `json:"vulnerabilities"`
	}

	CheckPackagesResult = []PackageVulnerabilities
)

func (s Issues) Len() int {
	return len(s)
}

func (s Issues) Less(i, j int) bool {
	return s[i].CVSSScore > s[j].CVSSScore
}

func (s Issues) Swap(i, j int) {
	s[i], s[j] = s[j], s[i]
}
