package config

import "a.yandex-team.ru/library/go/core/buildinfo"

const (
	Version = "0.2"
)

var (
	// FeedURI - feed url
	// where {distr} - GNU/Linux distributive to analyze, currently supported only ubuntu
	FeedURI = "https://yadi.yandex-team.ru/db/linux-{ecosystem}.json.gz"

	MinimumSeverity float32

	fullVersion string
)

func FullVersion() string {
	if fullVersion != "" {
		return fullVersion
	}

	if buildinfo.Info.ArcadiaSourceRevision != "" {
		fullVersion = Version + "." + buildinfo.Info.ArcadiaSourceRevision
	} else {
		fullVersion = Version
	}

	return fullVersion
}
