package debversion

import "regexp"

type (
	safeNumSlice    []int
	safeStringSlice []string
)

var (
	digitRegexp    = regexp.MustCompile(`[0-9]+`)
	nonDigitRegexp = regexp.MustCompile(`[^0-9]+`)
)

// get function returns 0, if the slice does not have the specified index.
func (n safeNumSlice) get(i int) int {
	if len(n) > i {
		return n[i]
	}
	return 0
}

// get function returns "", if the slice does not have the specified index.
func (s safeStringSlice) get(i int) string {
	if len(s) > i {
		return s[i]
	}
	return ""
}
