package feed

/*
  {
    "reference": "https://yadi-test.sec.yandex-team.ru/vulns/vuln/YADI-LINUX-KERNEL-2016-3156",
    "language": "linux-kernel",
    "title": "CVE-2016-3156: Resource Management Errors",
    "vulnerable_versions": ">=3.16 <3.16.35 || >=4.4 <4.4.8",
    "cvss_score": 5.5,
    "module_name": "linux",
    "id": "YADI-LINUX-KERNEL-2016-3156",
  }
*/

type Entry struct {
	ID                 string  `json:"id"`
	ModuleName         string  `json:"module_name"`
	Reference          string  `json:"reference"`
	Summary            string  `json:"title"`
	VulnerableVersions string  `json:"vulnerable_versions"`
	CVSSScore          float32 `json:"cvss_score"`
}

type Feed []Entry
