package feed

import (
	"a.yandex-team.ru/security/libs/go/semver"
)

type (
	KernelVulnerability struct {
		ID          string              `json:"id"`
		RawVersions string              `json:"vulnerable_versions"`
		Versions    *semver.Constraints `json:"-"`
		Summary     string              `json:"summary"`
		Reference   string              `json:"reference"`
		CVSSScore   float32             `json:"cvss_score"`
	}

	KernelVulnerabilities []KernelVulnerability
)

func (v *KernelVulnerability) IsAffected(release *semver.Version) bool {
	return v.Versions.Check(release)
}
