package feed

type Options struct {
	// feed Url
	// Uri (or path to file) to download feed. May have placeholder for ecosystem
	// Example: https://yadi.yandex-team.ru/db/linux-{ecosystem}.json.gz
	FeedURI string

	// Ignore vulnerabilities that lower than that severity
	MinimumSeverity float32

	// Fetcher to use, instead create new one
	Fetcher *Fetcher

	VulnerabilitiesExclude map[string]struct{}
}
