package feed

type (
	PackagesFeed struct {
		fetcher                *Fetcher
		minimumSeverity        float32
		vulnerabilitiesExclude map[string]struct{}
	}
)

func NewPackagesFeed(opts Options) *PackagesFeed {
	return &PackagesFeed{
		fetcher:                prepareFetcher(opts),
		minimumSeverity:        opts.MinimumSeverity,
		vulnerabilitiesExclude: opts.VulnerabilitiesExclude,
	}
}

func (f *PackagesFeed) Fetch(distributive string) (PackagesVulnerabilities, error) {
	feed, err := f.fetcher.Fetch(distributive)
	if err != nil {
		return nil, err
	}

	result := PackagesVulnerabilities{}
	for _, entry := range feed {
		if _, excludedVuln := f.vulnerabilitiesExclude[entry.ID]; excludedVuln {
			continue
		}

		if entry.CVSSScore < f.minimumSeverity {
			continue
		}

		result[entry.ModuleName] = append(
			result[entry.ModuleName],
			PackageVulnerability{
				ID:          entry.ID,
				PackageName: entry.ModuleName,
				CVSSScore:   entry.CVSSScore,
				RawVersions: entry.VulnerableVersions,
				Summary:     entry.Summary,
				Reference:   entry.Reference,
			},
		)
	}

	return result, nil
}
