package jsonfmt

import (
	"encoding/json"

	"a.yandex-team.ru/security/libs/go/simplelog"
	"a.yandex-team.ru/security/yadi/yadi-os/pkg/analyze"
)

func ListFormatter(results analyze.ListPackagesResult) []byte {
	formatted, err := json.Marshal(results)
	if err != nil {
		simplelog.Error("failed to render results", "err", err)
	}
	return formatted
}

func CheckPackagesFormatter(results analyze.CheckPackagesResult) []byte {
	formatted, err := json.Marshal(results)
	if err != nil {
		simplelog.Error("failed to render results", "err", err)
	}
	return formatted
}

func CheckKernelFormatter(results analyze.CheckKernelResult) []byte {
	formatted, err := json.Marshal(results)
	if err != nil {
		simplelog.Error("failed to render results", "err", err)
	}
	return formatted
}
