package protofmt

import (
	"google.golang.org/protobuf/proto"

	"a.yandex-team.ru/security/libs/go/simplelog"
	"a.yandex-team.ru/security/yadi/yadi-os/pkg/analyze"
	"a.yandex-team.ru/security/yadi/yadi-os/pkg/formatter/protofmt/yadi_os_out"
)

func ListFormatter(results analyze.ListPackagesResult) []byte {
	pkgs := make([]*yadi_os_out.Package, len(results))
	for i, pkg := range results {
		pkgs[i] = &yadi_os_out.Package{
			Name:          pkg.Name,
			Version:       pkg.RawVersion,
			SourceName:    pkg.SourceName,
			SourceVersion: pkg.RawSourceVersion,
		}
	}

	formatted, err := proto.Marshal(&yadi_os_out.ListResult{Packages: pkgs})
	if err != nil {
		simplelog.Error("failed to render results", "err", err)
	}
	return formatted
}

func CheckPackagesFormatter(results analyze.CheckPackagesResult) []byte {
	pkgs := make([]*yadi_os_out.VulnerablePackage, len(results))
	for i, vulnPkg := range results {
		issues := make([]*yadi_os_out.Issue, len(vulnPkg.Vulnerabilities))
		for k, issue := range vulnPkg.Vulnerabilities {
			issues[k] = &yadi_os_out.Issue{
				Id:               issue.ID,
				AffectedVersions: issue.AffectedVersions,
				Reference:        issue.Reference,
				Summary:          issue.Summary,
				CvssScore:        issue.CVSSScore,
			}
		}
		pkgs[i] = &yadi_os_out.VulnerablePackage{
			Package: &yadi_os_out.Package{
				Name:          vulnPkg.Package.Name,
				Version:       vulnPkg.Package.RawVersion,
				SourceName:    vulnPkg.Package.SourceName,
				SourceVersion: vulnPkg.Package.RawSourceVersion,
			},
			Vulnerabilities: issues,
		}
	}

	formatted, err := proto.Marshal(&yadi_os_out.CheckPackagesResult{Packages: pkgs})
	if err != nil {
		simplelog.Error("failed to render results", "err", err)
	}
	return formatted
}

func CheckKernelFormatter(results analyze.CheckKernelResult) []byte {
	issues := make([]*yadi_os_out.Issue, len(results))
	for k, issue := range results {
		issues[k] = &yadi_os_out.Issue{
			Id:               issue.ID,
			AffectedVersions: issue.AffectedVersions,
			Reference:        issue.Reference,
			Summary:          issue.Summary,
			CvssScore:        issue.CVSSScore,
		}
	}

	formatted, err := proto.Marshal(&yadi_os_out.CheckKernelResult{Issues: issues})
	if err != nil {
		simplelog.Error("failed to render results", "err", err)
	}
	return formatted
}
