package textfmt

import (
	"bytes"
	"text/template"

	"a.yandex-team.ru/security/libs/go/simplelog"
	"a.yandex-team.ru/security/yadi/libs/cvs"
	"a.yandex-team.ru/security/yadi/yadi-os/pkg/analyze"
)

const listTmpl = `
{{- range $i, $result := . }}
  - package name: {{ $result.Name }}
  - version: {{ $result.RawVersion }}
{{ end }}
`

const checkPackagesTmpl = `
{{- range $i, $result := . }}

  - package:
    - name: {{ $result.Package.Name }}
    - version: {{ $result.Package.RawVersion }}
{{- if $result.Package.SourceName }}
    - source name: {{ $result.Package.SourceName }}
{{ if $result.Package.RawSourceVersion}}    - source version: {{ $result.Package.RawSourceVersion }}{{ end }}
{{- end }}
  - vulnerabilities:
{{- range $i, $vuln := $result.Vulnerabilities }}
    - {{ cvssToSeverity $vuln.CVSSScore }} severity vulnerability:
      * desc: {{ $vuln.Summary }}
      * id: {{ $vuln.ID }}
      * info: {{ $vuln.Reference }}
      * vulnerable versions: {{ $vuln.AffectedVersions }}
{{- end -}}
{{ end }}
`

const checkKernelTmpl = `
{{- range $i, $vuln := . }}
  - {{ cvssToSeverity $vuln.CVSSScore }} severity vulnerability:
    * desc: {{ $vuln.Summary }}
    * id: {{ $vuln.ID }}
    * info: {{ $vuln.Reference }}
    * vulnerable versions: {{ $vuln.AffectedVersions }}
{{ end }}
`

var templateFns = template.FuncMap{
	"cvssToSeverity": cvs.ToSeverity,
}

func ListFormatter(results analyze.ListPackagesResult) []byte {
	t := template.Must(template.New("text_analyze_result").Funcs(templateFns).Parse(listTmpl))
	var out bytes.Buffer
	err := t.Execute(&out, results)
	if err != nil {
		simplelog.Error("failed to render list results", "err", err)
	}
	return out.Bytes()
}

func CheckPackagesFormatter(results analyze.CheckPackagesResult) []byte {
	t := template.Must(template.New("text_pkgs_result").Funcs(templateFns).Parse(checkPackagesTmpl))
	var out bytes.Buffer
	err := t.Execute(&out, results)
	if err != nil {
		simplelog.Error("failed to render list results", "err", err)
	}
	return out.Bytes()
}

func CheckKernelFormatter(results analyze.CheckKernelResult) []byte {
	t := template.Must(template.New("text_kernel_result").Funcs(templateFns).Parse(checkKernelTmpl))
	var out bytes.Buffer
	err := t.Execute(&out, results)
	if err != nil {
		simplelog.Error("failed to render list results", "err", err)
	}
	return out.Bytes()
}
