package hostctl

import (
	"bytes"
	"text/template"

	"a.yandex-team.ru/security/libs/go/simplelog"
	"a.yandex-team.ru/security/yadi/libs/cvs"
	"a.yandex-team.ru/security/yadi/yadi-os/pkg/analyze"
)

const resultsTmpl = `
{{- range $i, $vulnPack := . }}
{{- range $k, $result := $vulnPack.Vulnerabilities }}
  - package:
  - name: {{ $result.Package.Name }}
  - version: {{ $result.Package.RawVersion }}
{{- if $result.Package.SourceName }}
  - source name: {{ $result.Package.SourceName }}
{{ if $result.Package.RawSourceVersion}}    - source version: {{ $result.Package.RawSourceVersion }}{{ end }}
{{- end }}
  - vulnerabilities:
{{- range $i, $vuln := $result.Vulnerabilities }}
    - {{ cvssToSeverity $vuln.CVSSScore }} severity vulnerability:
      * desc: {{ $vuln.Summary }}
      * id: {{ $vuln.ID }}
      * info: {{ $vuln.Reference }}
      * vulnerable versions: {{ $vuln.AffectedVersions }}
{{- end -}}
{{- end -}}
{{ end }}
`

type Result struct {
	Vulnerabilities []analyze.PackageVulnerabilities `json:"vulnerabilities"`
	Hosts           []string                         `json:"hosts"`
}

func FormatResults(results []Result) []byte {
	t := template.Must(
		template.New("hostctl_result").
			Funcs(template.FuncMap{
				"cvssToSeverity": cvs.ToSeverity,
			}).
			Parse(resultsTmpl),
	)

	var out bytes.Buffer
	err := t.Execute(&out, results)
	if err != nil {
		simplelog.Error("failed to render results", "err", err)
	}
	return out.Bytes()
}
