//go:build linux
// +build linux

package kernel

import (
	"strings"
	"syscall"

	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/security/libs/go/semver"
)

func Current() (*Kernel, error) {
	var buf syscall.Utsname
	if err := syscall.Uname(&buf); err != nil {
		return nil, xerrors.Errorf("failed to get uname: %w", err)
	}

	rawKernelRelease := strings.Trim(utsnameStr(buf.Release[:]), "\x00")

	return Parse(rawKernelRelease)
}

func Parse(uname string) (*Kernel, error) {
	// TODO(buglloc): fix it, this is bullshit
	if idx := strings.Index(uname, "-"); idx > 0 {
		uname = uname[:idx]
	}

	kernelRelease, err := semver.NewVersion(uname)
	if err != nil {
		return nil, xerrors.Errorf("failed to parse kernel release: %w", err)
	}

	return &Kernel{
		RawRelease: uname,
		Release:    kernelRelease,
	}, nil
}
