package pkgmanager

import (
	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/security/libs/go/lineage"
	"a.yandex-team.ru/security/yadi/yadi-os/pkg/pkgmanager/apk"
	"a.yandex-team.ru/security/yadi/yadi-os/pkg/pkgmanager/dpkg"
	"a.yandex-team.ru/security/yadi/yadi-os/pkg/pkgmanager/manager"
)

var (
	ErrUnsupportedOs = xerrors.NewSentinel("unsupported OS family")
)

func DetectPkgManager(root string) (manager.Manager, error) {
	currentOS, err := lineage.OSInRoot(root)
	if err != nil {
		return nil, xerrors.Errorf("failed to detect OS: %w", err)
	}

	switch currentOS.Family {
	case lineage.Ubuntu, lineage.Debian:
		return dpkg.NewManager(dpkg.ManagerOpts{
			OS:   currentOS,
			Root: root,
		})
	case lineage.Alpine:
		return apk.NewManager(apk.ManagerOpts{
			OS:   currentOS,
			Root: root,
		})
	default:
		return nil, ErrUnsupportedOs.WithFrame()
	}

}
