package manager

import (
	"fmt"

	"a.yandex-team.ru/security/yadi/yadi-os/pkg/debversion"
)

type Package struct {
	Name             string              `json:"name"`
	Version          *debversion.Version `json:"-"`
	RawVersion       string              `json:"version"`
	SourceName       string              `json:"source_name"`
	SourceVersion    *debversion.Version `json:"-"`
	RawSourceVersion string              `json:"source_version"`

	fullName string
}

func (p *Package) FullName() string {
	if p.fullName == "" {
		p.fullName = fmt.Sprintf("%s@%s", p.Name, p.Version)
	}

	return p.fullName
}

func (p Package) String() string {
	return fmt.Sprintf("%s@%s", p.Name, p.RawVersion)
}
