package mockmngr

import (
	"a.yandex-team.ru/security/yadi/yadi-os/pkg/pkgmanager/manager"
)

type (
	ManagerInfo struct {
		Name                 string
		Distributive         string
		DistributiveCodename string
		Packages             []*manager.Package
	}

	Manager struct {
		mi ManagerInfo
	}
)

var _ manager.Manager = (*Manager)(nil)

func NewManager(info ManagerInfo) *Manager {
	return &Manager{mi: info}
}

func (m *Manager) Name() string {
	return m.mi.Name
}

func (m *Manager) Distributive() string {
	return m.mi.Distributive
}

func (m *Manager) DistributiveCodename() string {
	return m.mi.DistributiveCodename
}

func (m *Manager) Packages() ([]*manager.Package, error) {
	return m.mi.Packages, nil
}
