package splunk

const (
	FieldOsPlatform    = "os_platform"
	FieldOsCodename    = "os_codename"
	FieldPkgName       = "pkg_name"
	FieldPkgVer        = "pkg_ver"
	FieldKernelVersion = "kernel_version"
	FieldVulnerable    = "vulnerable"
	FieldVulnID        = "vuln_id"
	FieldVulnVersions  = "vuln_versions"
	FieldVulnSummary   = "vuln_summary"
	FieldVulnReference = "vuln_reference"
	FieldVulnSeverity  = "vuln_severity"
)

type BaseEntry struct {
	Issues    []Issue
	allFields []string
}

type PackageEntry struct {
	BaseEntry
	OsPlatform string
	OsCodename string
	PkgName    string
	PkgVer     string
}

type KernelEntry struct {
	BaseEntry
	KernelVersion string
}

type Issue struct {
	ID               string
	AffectedVersions string
	Summary          string
	Reference        string
	CVSSScore        float32
}

func filterStringIndexes(in []string, ignoredIndexes map[int]struct{}) []string {
	if len(ignoredIndexes) == 0 {
		return in
	}

	n := 0
	for i, v := range in {
		if _, ok := ignoredIndexes[i]; ok {
			continue
		}
		in[n] = v
		n++
	}
	return in[:n]
}
