package splunk

type options struct {
	fixableOnly     bool
	skipUnsupported bool
	feedURI         string
	minSeverity     float32
}

type Option func(*options)

func WithMinSeverity(severity float32) Option {
	return func(o *options) {
		o.minSeverity = severity
	}
}

func WithFixableOnly(fixableOnly bool) Option {
	return func(o *options) {
		o.fixableOnly = fixableOnly
	}
}

func WithFeedURI(feedURI string) Option {
	return func(o *options) {
		o.feedURI = feedURI
	}
}

func WithSkipUnsupported(skip bool) Option {
	return func(o *options) {
		o.skipUnsupported = skip
	}
}
