package integration

import (
	"sync"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/zap"
	"a.yandex-team.ru/security/libs/go/boombox/httpreplay"
	"a.yandex-team.ru/security/libs/go/boombox/tape"
)

var (
	YadiTapePath = "yadi_e2e.bolt"
	YadiTapeRo   = true
	yadiTape     *tape.Tape
	yadiTapeOnce sync.Once
)

func YadiTape() *tape.Tape {
	yadiTapeOnce.Do(func() {
		var opts []tape.Option
		if YadiTapeRo {
			opts = append(opts, tape.WithReadOnly())
		}

		var err error
		yadiTape, err = tape.NewTape(YadiTapePath, opts...)
		if err != nil {
			panic(err)
		}
	})

	return yadiTape
}

func NewGoProxy(proxy bool) (*httpreplay.Replay, error) {
	opts := []httpreplay.Option{
		httpreplay.WithLogger(newLogger()),
		httpreplay.WithNamespace("goproxy"),
		httpreplay.WithFollowRedirect(true),
	}

	if proxy {
		opts = append(opts, httpreplay.WithProxyMode("http://kirby.sec.yandex.net"))
	}

	r, err := httpreplay.NewReplay(YadiTape(), opts...)
	if err != nil {
		return nil, err
	}

	return r, nil
}

func NewYadiAPI(proxy bool) (*httpreplay.Replay, error) {
	opts := []httpreplay.Option{
		httpreplay.WithLogger(newLogger()),
		httpreplay.WithNamespace("yadi"),
	}

	if proxy {
		opts = append(opts, httpreplay.WithProxyMode("https://yadi.yandex-team.ru"))
	}

	r, err := httpreplay.NewReplay(YadiTape(), opts...)
	if err != nil {
		return nil, err
	}

	return r, nil
}

func NewNpmAPI(proxy bool) (*httpreplay.Replay, error) {
	opts := []httpreplay.Option{
		httpreplay.WithLogger(newLogger()),
		httpreplay.WithNamespace("npm"),
	}

	if proxy {
		opts = append(opts, httpreplay.WithProxyMode("http://npm.yandex-team.ru"))
	}

	r, err := httpreplay.NewReplay(YadiTape(), opts...)
	if err != nil {
		return nil, err
	}

	return r, nil
}

func newLogger() log.Logger {
	l, err := zap.New(zap.ConsoleConfig(log.DebugLevel))
	if err != nil {
		panic(err)
	}
	return l
}
