package cli

import (
	"bytes"
	"io/ioutil"

	"github.com/BurntSushi/toml"

	"a.yandex-team.ru/security/yadi/libs/cvs"
	"a.yandex-team.ru/security/yadi/yadi/internal/config"
	"a.yandex-team.ru/security/yadi/yadi/internal/service"
)

func WriteConfig(path string, project *service.ProjectInfo) error {
	cfg := config.ProjectConfig{
		Service:    project.Service,
		Name:       project.Name,
		Severity:   cvs.ToSeverity(project.Severity),
		NoSuggest:  !config.SuggestUpdate,
		IncludeDev: config.CheckDevDependencies,
		Skips:      config.SkipIssues,
		Targets:    project.Targets,
		JsOnly:     config.AllowJs && !config.AllowPython,
		PythonOnly: !config.AllowJs && config.AllowPython,
	}

	var buf bytes.Buffer
	err := toml.NewEncoder(&buf).Encode(cfg)
	if err != nil {
		return err
	}

	err = ioutil.WriteFile(path, buf.Bytes(), 0600)
	if err != nil {
		return err
	}

	return nil
}

func ReadConfig(path string) (config.ProjectConfig, error) {
	var cfg config.ProjectConfig
	_, err := toml.DecodeFile(path, &cfg)
	if err != nil {
		return cfg, err
	}

	return cfg, nil
}
