package commands

import (
	"context"
	"errors"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/security/yadi/yadi/internal/cli"
)

var lsCmd = &cobra.Command{
	Use:   "ls [flags] [/path/to/dependencies/file|...]",
	Short: "List project dependencies",
	Long:  "List project dependencies.",
	RunE:  runLsCmd,
}

func init() {
	RootCmd.AddCommand(lsCmd)
}

func runLsCmd(cmd *cobra.Command, args []string) error {
	var targets []string
	if len(opts.Targets) > 0 && len(args) == 0 {
		targets = cli.ValidateTargets(opts.Targets, true)
	} else if opts.Recursive {
		dirs := args
		if len(dirs) == 0 {
			dirs = []string{"."}
		}

		for _, dir := range dirs {
			targets = append(targets, cli.FindTargets(dir)...)
		}
	} else {
		candidates := args
		explicit := true
		if len(candidates) == 0 {
			candidates = projectFiles
			explicit = false
		}

		targets = cli.ValidateTargets(candidates, explicit)
	}

	if len(targets) == 0 {
		return errors.New("can't find any targets to analyze")
	}

	outer, err := cli.ListFormatter(cli.ListOptions{
		Format:    opts.Format,
		Project:   opts.ProjectName,
		Languages: specifiedLanguages(),
	})
	if err != nil {
		return err
	}
	defer func() { _ = outer.Close() }()

	err = cli.ListTargets(context.Background(), cli.DepsOptions{
		FuzzySearch: true,
		ResolveMode: cli.FetcherFlags(opts.Local, opts.Remote),
		Targets:     targets,
		ListOutput:  outer,
	})
	if err != nil {
		return err
	}

	return nil
}

func specifiedLanguages() (result []string) {
	m := map[string]bool{
		"python": opts.PythonOnly,
		"nodejs": opts.JsOnly,
		"golang": opts.GoOnly,
		"java":   opts.JavaOnly,
	}
	for lang, statement := range m {
		if statement {
			result = append(result, lang)
		}
	}
	return
}
