package config

import (
	"fmt"

	"a.yandex-team.ru/library/go/core/buildinfo"
)

const (
	ProductName = "Yadi"
	Version     = "0.5"
)

var (
	YadiHost         = "https://yadi.yandex-team.ru"
	NpmRepositoryURI = "http://npm.yandex-team.ru"
	// FeedURI - feed url
	// where {lang} - Language to analyze, currently supported nodejs and python
	FeedURI              = "https://yadi.yandex-team.ru/db/{lang}.json.gz"
	SkipIssues           []string
	MinimumSeverity      float32
	SuggestUpdate        = true
	NoPypiCache          = false
	CheckDevDependencies = false
	AllowPython          = true
	AllowJs              = true
	AllowGo              = true
	AllowBazelMaven      = true
	AllowJava            = true

	fullVersion string
)

func FullVersion() string {
	if fullVersion != "" {
		return fullVersion
	}

	patch := buildinfo.Info.ArcadiaSourceRevision
	if patch == "" || patch == "-1" {
		patch = "0"
	}
	return fmt.Sprintf("%s.%s", Version, patch)
}
