package httputils

import (
	"net/http"
	"time"

	"a.yandex-team.ru/security/libs/go/yahttp"
)

var HTTPClient = yahttp.NewClient(yahttp.Config{
	// Redirects must be allowed by default because PyPi love it.
	RedirectPolicy: yahttp.RedirectFollow,
	DialTimeout:    4 * time.Second,
	Timeout:        20 * time.Second,
})

func DoGet(url string) (*http.Response, error) {
	return HTTPClient.Get(url)
}

var GracefulClose = yahttp.GracefulClose
