package service

import (
	"a.yandex-team.ru/security/yadi/yadi/internal/results"
)

type ProjectInfo struct {
	Service     string   `json:"service"`
	Name        string   `json:"name"`
	Owners      string   `json:"owners"`
	RepoURI     string   `json:"repo_uri"`
	AccessToken string   `json:"access_token"`
	Targets     []string `json:"targets"`
	Skips       []string `json:"skips"`
	Severity    float32  `json:"severity"`
	Active      bool     `json:"active"`
}

type NewProjectInfo struct {
	ConfirmURI string `json:"confirm_uri"`
}

type ProjectSyncInfo struct {
	Service      string          `json:"-"`
	Name         string          `json:"-"`
	AccessToken  string          `json:"-"`
	Severity     *float32        `json:"severity,omitempty"`
	Targets      *[]string       `json:"targets,omitempty"`
	Skips        *[]string       `json:"skips,omitempty"`
	Dependencies *[]results.List `json:"dependencies,omitempty"`
}

type MinimumProjectInfo struct {
	Service     string
	Name        string
	AccessToken string
}
