package sliceutils

import (
	"a.yandex-team.ru/security/yadi/yadi/pkg/analyze"
)

func IntsEquals(a, b []int) bool {
	if len(a) != len(b) {
		return false
	}
	for i, v := range a {
		if v != b[i] {
			return false
		}
	}
	return true
}

func StrsEquals(a, b []string) bool {
	if len(a) != len(b) {
		return false
	}
	for i, v := range a {
		if v != b[i] {
			return false
		}
	}
	return true
}

func DepsEquals(moduleA, moduleB *analyze.ModuleTree) bool {
	if moduleA == moduleB {
		return true
	}

	if moduleA.PackageName != moduleB.PackageName {
		return false
	}
	if moduleA.Version != moduleB.Version {
		return false
	}
	if moduleA.From != moduleB.From {
		return false
	}
	if len(moduleA.Dependencies) != len(moduleB.Dependencies) {
		return false
	}

	for i := range moduleA.Dependencies {
		found := false
		for k := range moduleB.Dependencies {
			if DepsEquals(&moduleA.Dependencies[i], &moduleA.Dependencies[k]) {
				found = true
				break
			}
		}
		if !found {
			return false
		}
	}

	return true
}
