package analyze

import (
	"github.com/hashicorp/golang-lru/simplelru"

	"a.yandex-team.ru/security/yadi/yadi/pkg/manager"
)

type issueCache struct {
	cache *simplelru.LRU
}

func newIssueCache() *issueCache {
	c, err := simplelru.NewLRU(
		2048, // allow to configure
		simplelru.EvictCallback(nil),
	)
	if err != nil {
		// unreachable
		panic(err)
	}

	return &issueCache{
		cache: c,
	}
}

func (c *issueCache) GetFor(module manager.Module) (IssueList, bool) {
	item, ok := c.cache.Get(module.String())
	if !ok {
		return nil, false
	}
	return item.(IssueList), true
}

func (c *issueCache) SaveFor(module manager.Module, issues IssueList) {
	c.cache.Add(module.String(), issues)
}
