package analyze

import "a.yandex-team.ru/security/yadi/yadi/pkg/feed"

type AnalyzerOption func(*analyzer)

// WithFeedOptions allows to configure feed
func WithFeedOptions(opts feed.Options) AnalyzerOption {
	return func(a *analyzer) {
		a.feedFetcher = feed.New(opts)
	}
}

// WithFeedFetcher gets configured feed fetcher
func WithFeedFetcher(fetcher *feed.Fetcher) AnalyzerOption {
	return func(a *analyzer) {
		a.feedFetcher = fetcher
	}
}

// WithStatsTracking enables or disables dev/prod dependencies
func WithStatsTracking(track bool) AnalyzerOption {
	return func(a *analyzer) {
		a.trackStats = track
	}
}

// WithSuggest enables or disables update suggesting
func WithSuggest(suggest bool) AnalyzerOption {
	return func(a *analyzer) {
		a.suggestUpdate = suggest
	}
}

// WithVulnerabilityExcludes setups list of excluded vulnerabilities
func WithVulnerabilityExcludes(excludes []string) AnalyzerOption {
	return func(a *analyzer) {
		a.vulnsExclude = make(map[string]struct{}, len(excludes))

		for _, id := range excludes {
			a.vulnsExclude[id] = struct{}{}
		}
	}
}
