package analyze

import (
	"a.yandex-team.ru/security/yadi/yadi/pkg/feed"
	"a.yandex-team.ru/security/yadi/yadi/pkg/manager"
)

type (
	moduleTree struct {
		Module       manager.Module
		From         string
		Dependencies []moduleTree
	}

	workContext struct {
		vulnerabilities feed.Vulnerabilities
		pm              manager.PackageManager
		stats           *DependencyStats
		depExcludes     map[string]struct{}
	}
)

func (t *moduleTree) String() string {
	return t.Module.String()
}

func (t *moduleTree) ResultModuleTree() ModuleTree {
	var ver string
	if t.Module.Version != nil {
		ver = t.Module.Version.String()
	}

	result := ModuleTree{
		PackageName:  t.Module.Name,
		License:      t.Module.License,
		Version:      ver,
		From:         t.From,
		Dependencies: make([]ModuleTree, len(t.Dependencies)),
	}

	for i, subTree := range t.Dependencies {
		result.Dependencies[i] = subTree.ResultModuleTree()
	}

	return result
}
