package feed

//go:generate easyjson

/*
   {
   	"id": "nsp:321",
   	"reference": "https://nodesecurity.io/advisories/321",
   	"title": "Insecure randomness",
   	"module_name": "socket.io",
   	"cvss_score": 4.8,
   	"patched_versions": ">=0.9.7",
   	"vulnerable_versions": "<=0.9.6"
   }
*/

//easyjson:json
type Entry struct {
	ID                 string  `json:"id"`
	ModuleName         string  `json:"module_name"`
	Reference          string  `json:"reference"`
	Summary            string  `json:"title"`
	VulnerableVersions string  `json:"vulnerable_versions"`
	PatchedVersions    string  `json:"patched_versions"`
	PatchExists        bool    `json:"patch_exists"`
	CVSSScore          float32 `json:"cvss_score"`
}

//easyjson:json
type Feed []Entry
