package feed

import (
	"strings"

	"a.yandex-team.ru/security/yadi/libs/versionarium"
)

type (
	Vulnerability struct {
		ID              string                    `json:"id"`
		PackageName     string                    `json:"package_name"`
		RawVersions     string                    `json:"vulnerable_versions"`
		PatchedVersions string                    `json:"patched_versions"`
		Versions        versionarium.VersionRange `json:"-"`
		Summary         string                    `json:"summary"`
		Reference       string                    `json:"reference"`
		CVSSScore       float32                   `json:"cvss_score"`
		PatchExists     bool                      `json:"patch_exists"`
	}

	Vulnerabilities map[string][]Vulnerability
)

func (v Vulnerability) IsAffected(name string, version versionarium.Version) bool {
	return v.PackageName == strings.ToLower(name) && v.Versions.Check(version)
}

func (v Vulnerability) CheckVersion(version versionarium.Version) bool {
	return v.Versions.Check(version)
}

func (v Vulnerabilities) ForPackage(name string) []Vulnerability {
	if result, found := v[strings.ToLower(name)]; found {
		return result
	}

	return nil
}
