package bazelmaven

import (
	"a.yandex-team.ru/security/libs/go/simplelog"
	"a.yandex-team.ru/security/yadi/libs/versionarium"
	"a.yandex-team.ru/security/yadi/yadi/pkg/manager"
)

const (
	name     = "bazelmaven"
	language = "java"
)

type (
	ManagerOpts struct {
		// Target file to parse
		TargetPath string
		WithDev    bool
	}

	Manager struct {
		target  string
		withDev bool
		graph   graph
	}
)

func NewManager(opts ManagerOpts) (*Manager, error) {
	graph, err := parseMavenInstallJSON(opts.TargetPath)
	if err != nil {
		return nil, err
	}
	return &Manager{
		graph:   graph,
		target:  opts.TargetPath,
		withDev: opts.WithDev,
	}, nil
}

func (m *Manager) Name() string {
	return name
}

func (m *Manager) Language() string {
	return language
}

func (m *Manager) TargetPath() string {
	return m.target
}

func (m *Manager) CanLocal() bool {
	return true
}

func (m *Manager) CanRemote() bool {
	return false
}

func (m *Manager) CanSuggest() bool {
	return false
}

func (m *Manager) Cacheable() bool {
	return false
}

func (m *Manager) RootModules() ([]manager.Module, error) {
	module, err := m.graph.resolveTree(resolveOpts{withDev: m.withDev, targetPath: m.TargetPath()})
	if err != nil {
		simplelog.Error("failed to resolve module", "err", err)
		return nil, err
	} else {
		return []manager.Module{module}, nil
	}
}

func (m *Manager) ResolveLocalDependency(dep manager.Dependency, _ manager.Module) (manager.Module, error) {
	return manager.Module{
		Name:         dep.Name,
		Version:      dep.ResolvedVersion,
		Dependencies: dep.ResolvedDependencies,
		LocalPath:    m.target,
	}, nil
}

func (m *Manager) ResolveRemoteDependency(_ manager.Dependency, _ manager.Module) (manager.Module, error) {
	panic("not implemented: must not be called")
}

func (m *Manager) SuggestModuleUpdate(_ manager.Module, _ versionarium.VersionRange, _ []manager.Module) []string {
	return nil
}
