package manager

import (
	"fmt"

	"a.yandex-team.ru/security/libs/go/simplelog"
	"a.yandex-team.ru/security/yadi/libs/versionarium"
)

type Dependency struct {
	Name                 string
	RawVersions          string
	IsDev                bool
	Language             string
	LocalPath            string
	ResolvedVersion      versionarium.Version
	ResolvedDependencies []Dependency
	versions             versionarium.VersionRange
	fullName             string
}

func (p *Dependency) FullName() string {
	if p.fullName == "" {
		p.fullName = fmt.Sprintf("%s@%s", p.Name, p.RawVersions)
	}
	return p.fullName
}

func (p *Dependency) IsStrictlyLocal() bool {
	return p.LocalPath != ""
}

func (p *Dependency) CheckVersion(v versionarium.Version) bool {
	if v == nil {
		return false
	}

	if p.RawVersions == "" {
		return false
	}

	if p.versions == nil {
		versions, err := versionarium.NewRange(p.Language, p.RawVersions)
		if err != nil {
			simplelog.Error("failed to parse dependency versions",
				"module", p,
				"versions", p.RawVersions,
			)

			// TODO(buglloc): ugly
			p.RawVersions = ""
			return false
		}
		p.versions = versions
	}

	return p.versions.Check(v)
}
