package manager

import (
	"fmt"
	"strings"

	"a.yandex-team.ru/security/yadi/libs/versionarium"
)

var ZeroModule = Module{}

type Module struct {
	Name         string
	LocalPath    string
	Version      versionarium.Version
	License      string
	Dependencies []Dependency
	moduleStr    string
}

func (m *Module) String() string {
	if m.moduleStr != "" {
		return m.moduleStr
	}

	if m.Version != nil {
		m.moduleStr = fmt.Sprintf("%s@%s", m.Name, m.Version)
		return m.moduleStr
	}

	m.moduleStr = m.Name
	return m.moduleStr
}

func (m *Module) IsEmpty() bool {
	return m == nil || m.Name == ""
}

func BuildPath(modules []Module) []string {
	out := make([]string, len(modules))
	for i := len(modules) - 1; i >= 0; i-- {
		out[i] = modules[i].String()
	}
	return out
}

func BuildTextPath(modules []Module) string {
	return strings.Join(BuildPath(modules), " > ")
}
