package npm

import (
	"encoding/json"
	"sort"
	"sync"

	"a.yandex-team.ru/security/yadi/libs/versionarium"
)

type PackageVersions []PackageJSON

type Response struct {
	Versions map[string]PackageJSON
}

var packageVersionsCache map[string]PackageVersions
var cacheLock *sync.Mutex

func init() {
	packageVersionsCache = make(map[string]PackageVersions)
	cacheLock = &sync.Mutex{}
}

func FetchPackageVersions(name string) (PackageVersions, error) {
	cacheLock.Lock()
	if val, ok := packageVersionsCache[name]; ok {
		cacheLock.Unlock()
		return val, nil
	}

	cacheLock.Unlock()
	// TODO(buglloc): deal with strictly local packages!
	saveToCache := func(pkgs map[string]PackageJSON) PackageVersions {
		packageVersions := make(PackageVersions, len(pkgs))
		i := 0
		for _, pkg := range pkgs {
			packageVersions[i] = pkg
			packageVersions[i].Version, _ = versionarium.NewVersion(lang, pkg.RawVersion) //TODO(melkikh): continue?
			i++
		}

		sort.Sort(packageVersions)
		cacheLock.Lock()
		packageVersionsCache[name] = packageVersions
		cacheLock.Unlock()
		return packageVersions
	}

	body, err := fetchNpm(name)
	if err != nil {
		return saveToCache(nil), err
	}

	var resp Response
	err = json.Unmarshal(body, &resp)
	if err != nil {
		return saveToCache(nil), err
	}

	return saveToCache(resp.Versions), nil
}

func (slice PackageVersions) Len() int {
	return len(slice)
}

func (slice PackageVersions) Less(i, j int) bool {
	if slice[i].Version == nil || slice[j].Version == nil {
		return false
	}

	return slice[i].Version.LessThan(slice[j].Version)
}

func (slice PackageVersions) Swap(i, j int) {
	slice[i], slice[j] = slice[j], slice[i]
}
