package remote

import (
	"a.yandex-team.ru/security/yadi/libs/versionarium"
	"a.yandex-team.ru/security/yadi/yadi/pkg/manager/pip/requirements"
)

type Repo interface {
	FetchVersions(name string) (PkgVersions, error)
}

type Pkg interface {
	Name() string
	RawVersion() string
	Version() versionarium.Version
	Requirements() (*requirements.Requirements, error)
	License() (string, error)
}

type PkgVersions []Pkg

func (slice PkgVersions) Len() int {
	return len(slice)
}

func (slice PkgVersions) Less(i, j int) bool {
	if slice[i].Version() == nil || slice[j].Version() == nil {
		return false
	}
	var iv, jv = slice[i].Version(), slice[j].Version()
	return iv.LessThan(jv)
}

func (slice PkgVersions) Swap(i, j int) {
	slice[i], slice[j] = slice[j], slice[i]
}
