package remote

import (
	"sync"

	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/security/yadi/libs/pypi"
	"a.yandex-team.ru/security/yadi/libs/versionarium"
	"a.yandex-team.ru/security/yadi/yadi/pkg/manager/pip/requirements"
)

type (
	SimplePkg struct {
		pkg          *pypi.Package
		rawVersion   string
		version      versionarium.Version
		license      string
		fetched      bool
		fetchErr     error
		requirements *requirements.Requirements
		lock         sync.Mutex
	}
)

func (p *SimplePkg) Name() string {
	return p.pkg.Name()
}

func (p *SimplePkg) RawVersion() string {
	return p.rawVersion
}

func (p *SimplePkg) Version() versionarium.Version {
	return p.version
}

func (p *SimplePkg) License() (string, error) {
	p.lock.Lock()
	defer p.lock.Unlock()

	if !p.fetched {
		p.fetch()
	}

	return p.license, p.fetchErr
}

func (p *SimplePkg) Requirements() (*requirements.Requirements, error) {
	p.lock.Lock()
	defer p.lock.Unlock()

	if !p.fetched {
		p.fetch()
	}

	return p.requirements, p.fetchErr
}

func (p *SimplePkg) fetch() {
	p.fetched = true

	version, err := p.pkg.Version(p.rawVersion)
	if err != nil {
		p.fetchErr = xerrors.Errorf("failed to resolve pkg version %s: %w", p.rawVersion, err)
		return
	}

	reqs, err := version.Requirements()
	if err != nil {
		p.fetchErr = err
		return
	}

	p.license = version.License()
	p.requirements, p.fetchErr = requirements.ParseRemote(reqs)
}
