package remote

import (
	"sort"

	"github.com/karlseguin/ccache/v2"

	"a.yandex-team.ru/security/libs/go/simplelog"
	"a.yandex-team.ru/security/yadi/libs/pypi"
	"a.yandex-team.ru/security/yadi/libs/versionarium"
)

type (
	SimpleRemoteRepo struct {
		upstream      *pypi.PyPi
		versionsCache *ccache.Cache
	}
)

func NewSimpleRepo() (*SimpleRemoteRepo, error) {
	upstream, err := pypi.NewYandexTeamSimple()
	if err != nil {
		return nil, err
	}

	return &SimpleRemoteRepo{
		upstream:      upstream,
		versionsCache: ccache.New(ccache.Configure().MaxSize(1000)),
	}, nil
}

func (s *SimpleRemoteRepo) FetchVersions(name string) (PkgVersions, error) {
	versions, err := s.versionsCache.Fetch(name, cacheTTL, func() (interface{}, error) {
		pkg, err := s.upstream.FindPackage(name)
		if err != nil {
			return nil, err
		}

		err = pkg.Resolve()
		if err != nil {
			return nil, err
		}

		versions := pkg.Versions()
		result := make(PkgVersions, 0, len(versions))
		for _, ver := range versions {
			clearedVersion := clearVersionRe.FindStringSubmatch(ver)
			if len(clearedVersion) == 0 {
				simplelog.Warn("failed to clear version", "version", ver)
				continue
			}

			parsedVersion, err := versionarium.NewVersion(lang, clearedVersion[1])
			if err != nil {
				simplelog.Warn("failed to parse version", "version", ver)
				continue
			}

			result = append(result, &SimplePkg{
				pkg:        pkg,
				rawVersion: ver,
				version:    parsedVersion,
			})
		}

		sort.Sort(result)
		return result, nil
	})

	if err != nil {
		return nil, err
	}

	return versions.Value().(PkgVersions), nil
}
