package requirements

import (
	"a.yandex-team.ru/security/yadi/yadi/pkg/manager"
)

type Requirements struct {
	dependencies map[string][]manager.Dependency
}

func NewRequirements() *Requirements {
	return &Requirements{
		dependencies: make(map[string][]manager.Dependency),
	}
}

func (r *Requirements) AddDependency(dep manager.Dependency, extras string) error {
	key := "*"
	if extras != "" {
		key = extras
	}

	r.dependencies[key] = append(r.dependencies[key], dep)
	return nil
}

func (r *Requirements) AddDependencies(deps []manager.Dependency, extras string) error {
	key := "*"
	if extras != "" {
		key = extras
	}

	r.dependencies[key] = append(r.dependencies[key], deps...)
	return nil
}

func (r *Requirements) Dependencies(extras []string) []manager.Dependency {
	var result []manager.Dependency
	if deps, ok := r.dependencies["*"]; ok {
		result = append(result, deps...)
	}

	for _, extra := range extras {
		if deps, ok := r.dependencies[extra]; ok {
			result = append(result, deps...)
		}
	}
	return result
}

func (r *Requirements) Extras() (result []string) {
	for key := range r.dependencies {
		result = append(result, key)
	}
	return
}

func (r *Requirements) AllDependencies() (result []manager.Dependency) {
	for _, dep := range r.dependencies {
		result = append(result, dep...)
	}
	return
}

func (r *Requirements) Merge(source *Requirements) error {
	for key, deps := range source.dependencies {
		_ = r.AddDependencies(deps, key)
	}
	return nil
}
