package yarnparser

type TokenType int
type TokenValue interface{}

const (
	ILLEGAL TokenType = iota
	EOF
	NEWLINE
	INDENT
	BOOLEAN
	STRING
	NUMBER
	COMMENT
	COMMA
	COLON
)

type Token struct {
	Line int
	Col  int
	Type TokenType
	Val  TokenValue
}

func (t *Token) String() string {
	return t.Val.(string)
}

func (t *Token) Int() int {
	return t.Val.(int)
}

func (t *Token) Bool() bool {
	return t.Val.(bool)
}

func TokenTypeString(token TokenType) string {
	switch token {
	case ILLEGAL:
		return "Illegal"
	case EOF:
		return "Eof"
	case NEWLINE:
		return "NewLine"
	case INDENT:
		return "Indent"
	case BOOLEAN:
		return "Boolean"
	case STRING:
		return "String"
	case NUMBER:
		return "Number"
	case COMMENT:
		return "Comment"
	case COMMA:
		return "Comma"
	case COLON:
		return "Colon"
	}
	return "Unknown"
}
