package commonout

import (
	"fmt"
	"strings"

	"a.yandex-team.ru/security/yadi/libs/cvs"
	"a.yandex-team.ru/security/yadi/yadi/internal/config"
	"a.yandex-team.ru/security/yadi/yadi/internal/results"
	"a.yandex-team.ru/security/yadi/yadi/pkg/analyze"
)

type Summary struct {
	Issues      int
	Path        int
	MaxSeverity string
}

func FormatSuggest(issue analyze.Issue) string {
	if !config.SuggestUpdate {
		return ""
	}

	if len(issue.Suggest) == 0 {
		return "No direct dependency upgrade can address this issue."
	}

	suggests := issue.Suggest
	var suggest string
	if issue.Path[0] == suggests[0] {
		suggest = "Reinstall direct dependency " + issue.Path[0]
	} else {
		suggest = "Upgrade direct dependency " + issue.Path[0] + " to " + suggests[0]
	}

	if len(suggests) > 1 {
		suggest += fmt.Sprintf(" (triggers upgrades to %s)", strings.Join(suggests[1:], " > "))
	}
	return suggest
}

func CalculateSummary(results []results.Analyze) Summary {
	issues := make(map[string]bool)
	paths := 0
	maxCvs := float32(0.0)
	for _, res := range results {
		for _, issue := range res.Issues {
			issues[issue.ID] = true
			if maxCvs < issue.CVSSScore {
				maxCvs = issue.CVSSScore
			}
			paths++
		}
	}

	return Summary{
		Issues:      len(issues),
		Path:        paths,
		MaxSeverity: cvs.ToSeverity(maxCvs),
	}
}
