package jsonout

import (
	"encoding/json"
	"os"

	"a.yandex-team.ru/security/libs/go/simplelog"
	"a.yandex-team.ru/security/yadi/yadi/internal/results"
	"a.yandex-team.ru/security/yadi/yadi/pkg/outputs/outer"
)

var _ outer.IssueOutput = (*IssueOutput)(nil)

type IssueOutput struct {
}

func NewIssueOutput() *IssueOutput {
	return &IssueOutput{}
}

func (o *IssueOutput) WriteIssues(results []results.Analyze) {
	formatted, err := json.Marshal(results)
	if err != nil {
		simplelog.Error("failed to render results", "err", err)
	}
	_, _ = os.Stdout.Write(formatted)
}

func (o *IssueOutput) Close() error {
	return nil
}
