package textout

import (
	"fmt"
	"strings"

	"a.yandex-team.ru/security/yadi/yadi/pkg/analyze"
	"a.yandex-team.ru/security/yadi/yadi/pkg/manager"
	"a.yandex-team.ru/security/yadi/yadi/pkg/outputs/outer"
	"a.yandex-team.ru/security/yadi/yadi/pkg/outputs/writer"
)

var _ outer.ListOutput = (*ListOutput)(nil)

type ListOutput struct {
	ident  int
	writer *writer.Writer
}

type ListOption func(*ListOutput)

func WithWriter(w *writer.Writer) ListOption {
	return func(o *ListOutput) {
		o.writer = w
	}
}

func NewListOutput(opts ...ListOption) *ListOutput {
	o := &ListOutput{
		writer: writer.NewWriter(),
	}

	for _, opt := range opts {
		opt(o)
	}

	return o
}

func (o *ListOutput) EnterRootModule(module manager.Module, pm manager.PackageManager) {
	o.ident = 0
	_, _ = o.writer.WriteString(
		fmt.Sprintf("%s (%s, %s)\n", pm.TargetPath(), module.Name, pm.Language()),
	)
}

func (o *ListOutput) ExitRootModule(_ *analyze.DependencyStats) {}

func (o *ListOutput) EnterModule(module manager.Module, _ string, _ []manager.Module) {
	o.ident++
	_, _ = o.writer.WriteString(
		fmt.Sprintf("%s%s\n", strings.Repeat("  ", o.ident), module.String()),
	)
}

func (o *ListOutput) ExitModule() {
	o.ident--
}

func (o *ListOutput) Close() error {
	return o.writer.Close()
}
