package writer

import (
	"io"
	"os"
)

type Buf interface {
	io.Writer
	io.StringWriter
	io.ByteWriter
	Bytes() []byte
}

type StdOut struct {
	*os.File
}

func (s *StdOut) WriteByte(c byte) error {
	_, err := s.File.Write([]byte{c})
	return err
}

func (s *StdOut) Bytes() []byte {
	return nil
}
