package writer

type Option func(*Writer)

func WithPrintOnClose(print bool) Option {
	return func(w *Writer) {
		w.printOnClose = print
	}
}

func WithBuf(buf Buf) Option {
	return func(w *Writer) {
		w.Buf = buf
	}
}
