package writer

import (
	"bytes"
	"io"
	"os"

	"golang.org/x/crypto/ssh/terminal"
)

var _ io.Closer = (*Writer)(nil)
var _ Buf = (*Writer)(nil)

type Writer struct {
	Buf
	printOnClose bool
}

func NewWriter(opts ...Option) *Writer {
	w := &Writer{}
	for _, opt := range opts {
		opt(w)
	}

	if w.Buf == nil {
		if terminal.IsTerminal(int(os.Stdout.Fd())) {
			w.Buf = bytes.NewBuffer(nil)
			w.printOnClose = true
		} else {
			w.printOnClose = false
			w.Buf = &StdOut{
				File: os.Stdout,
			}
		}
	}

	return w
}

func (w *Writer) Close() error {
	if !w.printOnClose {
		return nil
	}

	b := w.Bytes()
	if len(b) == 0 {
		return nil
	}

	_, err := os.Stdout.Write(b)
	return err
}
