package cacher

import "fmt"

func selectEntryQuery(pathPrefix string) string {
	return fmt.Sprintf(`
PRAGMA TablePathPrefix("%s");
DECLARE $source AS Utf8;
DECLARE $hash AS Utf8;

SELECT
    results
FROM
    yaudit_cache
WHERE
	source = $source AND hash = $hash
LIMIT 1
;`, pathPrefix)
}

func upsertEntryQuery(pathPrefix string) string {
	return fmt.Sprintf(`
PRAGMA TablePathPrefix("%s");
DECLARE $source AS Utf8;
DECLARE $hash AS Utf8;
DECLARE $epoch AS Utf8;
DECLARE $results AS String;

UPSERT INTO yaudit_cache
    (source, hash, epoch, results)
VALUES
    ($source, $hash, $epoch, $results)
;`, pathPrefix)
}

func cleanupEntriesQuery(pathPrefix string) string {
	return fmt.Sprintf(`
PRAGMA TablePathPrefix("%s");
DECLARE $source AS Utf8;
DECLARE $epoch AS Utf8;

DELETE FROM yaudit_cache ON
	SELECT source, hash FROM yaudit_cache WHERE source = $source AND epoch != $epoch LIMIT 50
;`, pathPrefix)
}
