package config

import "time"

type (
	Config struct {
		Debug              bool
		WithDev            bool
		WithCache          bool
		HTTPPort           uint64
		YadiMaxConcurrency int
		FeedPath           string
		ManifestPath       string
		RequestTimeout     uint64
		HecSenderToken     string
		WatcherCronSpec    string
		Cacher             Cacher
		Cleaner            Cleaner
	}

	Cacher struct {
		Database string
		Path     string
		Endpoint string
	}

	Cleaner struct {
		YtProxy     string
		YtPath      string
		YtToken     string
		StartDelay  time.Duration
		CleanPeriod time.Duration
	}
)
