package middlewares

import (
	"bytes"
	"compress/gzip"
	"io/ioutil"
	"strings"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/security/libs/go/simplelog"
)

const (
	gzipScheme = "gzip"
)

func Gunzip() echo.MiddlewareFunc {
	return func(next echo.HandlerFunc) echo.HandlerFunc {
		return func(c echo.Context) error {

			req := c.Request()

			// decompress body with correct content-encoding
			if strings.Contains(c.Request().Header.Get(echo.HeaderContentEncoding), gzipScheme) {
				req.Header.Del(echo.HeaderContentEncoding)

				reader, err := ioutil.ReadAll(req.Body)
				if err != nil {
					return err
				}

				gr, err := gzip.NewReader(bytes.NewBuffer(reader))
				if err != nil {
					return err
				}
				defer func() {
					err := gr.Close()
					if err != nil {
						simplelog.Error("Failed to close Gunzip Reader", "err", err)
					}
				}()

				req.Body = ioutil.NopCloser(gr)
				req.Header.Set(echo.HeaderContentType, echo.MIMEApplicationJSON)

				// NB!
				// we don't update Content-Length header!

				return next(c)
			}

			return next(c)
		}
	}
}
