package npmaudit

//go:generate easyjson -all

import (
	"a.yandex-team.ru/security/yadi/libs/versionarium"
	"a.yandex-team.ru/security/yadi/yadi/pkg/manager/npm"
	"a.yandex-team.ru/security/yadi/yadi/pkg/manager/pkglock"
)

type NpmRequest struct {
	AppName      string                      `json:"name"`
	RawVersion   string                      `json:"version"`
	Version      versionarium.Version        `json:"-"`
	Requires     map[string]string           `json:"requires"`               // aka dependencies in package.json
	Dependencies *map[string]pkglock.LockDep `json:"dependencies,omitempty"` // aka dependencies in package-lock.json
}

type OkoRequest struct {
	WithDev         bool             `json:"with_dev"`
	PackageJSON     npm.PackageJSON  `json:"package"`
	PackageLockJSON pkglock.LockJSON `json:"package_lock"`
	YarnLock        string           `json:"yarn_lock"`
}
