package server

import (
	"errors"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/security/yadi/libs/cvs"
	"a.yandex-team.ru/security/yadi/yadi-os/pkg/analyze"
)

func (s *Server) ubuntuCheckHandler(c echo.Context) error {
	codename := c.QueryParam("codename")
	if codename == "" {
		return apiErr(c, errors.New("no 'codename' provided"))
	}

	pkgName := c.Param("name")
	pkgVersion := c.Param("version")

	issues, err := s.ubuntuAnalyzer.AnalyzePkg(codename, pkgName, pkgVersion)
	if err != nil {
		return apiErr(c, err)
	}

	if severity := c.QueryParam("severity"); severity != "" {
		minScore, _ := cvs.FromSeverity(severity)
		issues = filterIssues(issues, minScore)
	}

	return apiOk(c, issues)
}

func (s *Server) ubuntuDPKGHandler(c echo.Context) error {
	codename := c.QueryParam("codename")
	if codename == "" {
		return apiErr(c, errors.New("no 'codename' provided"))
	}

	results, err := s.ubuntuAnalyzer.AnalyzeMulti(codename, c.Request().Body)
	if err != nil {
		return apiErr(c, err)
	}

	if severity := c.QueryParam("severity"); severity != "" {
		minScore, _ := cvs.FromSeverity(severity)
		n := 0
		for _, res := range results {
			res.Vulnerabilities = filterIssues(res.Vulnerabilities, minScore)
			if len(res.Vulnerabilities) == 0 {
				continue
			}

			results[n] = res
			n++
		}

		results = results[:n]
	}

	return apiOk(c, results)
}

func filterIssues(issues []analyze.Issue, minScore float32) []analyze.Issue {
	n := 0
	for _, issue := range issues {
		if issue.CVSSScore < minScore {
			continue
		}

		issues[n] = issue
		n++
	}

	return issues[:n]
}
